package com.xforceplus.saasnotifierservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * risk_check_kind
 * </p>
 *
 * @author ultraman
 * @since 2024-11-08
 */
public enum RiskCheckKind {

    _1("1", "邮箱"),
    _2("2", "短信"),
    _3("3", "站内信"),
    _4("4", "微信"),
    _5("5", "钉钉"),
    _6("6", "飞书");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RiskCheckKind(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RiskCheckKind fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
