package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.IssueFailedAlarmHistory;
import com.xforceplus.saasnotifierservice.service.IIssueFailedAlarmHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-09
 */
@RestController
public class IssueFailedAlarmHistoryController {

  @Autowired
  private IIssueFailedAlarmHistoryService issueFailedAlarmHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param issueFailedAlarmHistory ${table.comment}
   * @return
   */
  @GetMapping("/issuefailedalarmhistorys" )
  public XfR getIssueFailedAlarmHistorys(XfPage page, IssueFailedAlarmHistory issueFailedAlarmHistory) {
    return XfR.ok(issueFailedAlarmHistoryServiceImpl.page(page, Wrappers.query(issueFailedAlarmHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/issuefailedalarmhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(issueFailedAlarmHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param issueFailedAlarmHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/issuefailedalarmhistorys")
  public XfR save(@RequestBody IssueFailedAlarmHistory issueFailedAlarmHistory) {
     return XfR.ok(issueFailedAlarmHistoryServiceImpl.save(issueFailedAlarmHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param issueFailedAlarmHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/issuefailedalarmhistorys/{id}")
  public XfR putUpdate(@RequestBody IssueFailedAlarmHistory issueFailedAlarmHistory,@PathVariable Long id) {
      issueFailedAlarmHistory.setId(id);
      return XfR.ok(issueFailedAlarmHistoryServiceImpl.updateById(issueFailedAlarmHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param issueFailedAlarmHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/issuefailedalarmhistorys/{id}")
  public XfR patchUpdate(@RequestBody IssueFailedAlarmHistory issueFailedAlarmHistory,@PathVariable Long id) {
      IssueFailedAlarmHistory upissueFailedAlarmHistory = issueFailedAlarmHistoryServiceImpl.getById(id);
      if(upissueFailedAlarmHistory != null){
        upissueFailedAlarmHistory = ObjectCopyUtils.copyProperties(issueFailedAlarmHistory,upissueFailedAlarmHistory,true);
      }
      return XfR.ok(issueFailedAlarmHistoryServiceImpl.updateById(upissueFailedAlarmHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/issuefailedalarmhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(issueFailedAlarmHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/issuefailedalarmhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "issue_failed_alarm_history");
     params.put("request", condition);

     return XfR.ok(issueFailedAlarmHistoryServiceImpl.querys(params));
  }

}
