package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.IssueFailedAlarmRecipientRel;
import com.xforceplus.saasnotifierservice.service.IIssueFailedAlarmRecipientRelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-09
 */
@RestController
public class IssueFailedAlarmRecipientRelController {

  @Autowired
  private IIssueFailedAlarmRecipientRelService issueFailedAlarmRecipientRelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param issueFailedAlarmRecipientRel ${table.comment}
   * @return
   */
  @GetMapping("/issuefailedalarmrecipientrels" )
  public XfR getIssueFailedAlarmRecipientRels(XfPage page, IssueFailedAlarmRecipientRel issueFailedAlarmRecipientRel) {
    return XfR.ok(issueFailedAlarmRecipientRelServiceImpl.page(page, Wrappers.query(issueFailedAlarmRecipientRel)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/issuefailedalarmrecipientrels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(issueFailedAlarmRecipientRelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param issueFailedAlarmRecipientRel ${table.comment}
   * @return XfR
   */
  @PostMapping("/issuefailedalarmrecipientrels")
  public XfR save(@RequestBody IssueFailedAlarmRecipientRel issueFailedAlarmRecipientRel) {
     return XfR.ok(issueFailedAlarmRecipientRelServiceImpl.save(issueFailedAlarmRecipientRel));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param issueFailedAlarmRecipientRel ${table.comment}
   * @return XfR
   */
  @PutMapping("/issuefailedalarmrecipientrels/{id}")
  public XfR putUpdate(@RequestBody IssueFailedAlarmRecipientRel issueFailedAlarmRecipientRel,@PathVariable Long id) {
      issueFailedAlarmRecipientRel.setId(id);
      return XfR.ok(issueFailedAlarmRecipientRelServiceImpl.updateById(issueFailedAlarmRecipientRel));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param issueFailedAlarmRecipientRel ${table.comment}
   * @return XfR
   */
  @PatchMapping("/issuefailedalarmrecipientrels/{id}")
  public XfR patchUpdate(@RequestBody IssueFailedAlarmRecipientRel issueFailedAlarmRecipientRel,@PathVariable Long id) {
      IssueFailedAlarmRecipientRel upissueFailedAlarmRecipientRel = issueFailedAlarmRecipientRelServiceImpl.getById(id);
      if(upissueFailedAlarmRecipientRel != null){
        upissueFailedAlarmRecipientRel = ObjectCopyUtils.copyProperties(issueFailedAlarmRecipientRel,upissueFailedAlarmRecipientRel,true);
      }
      return XfR.ok(issueFailedAlarmRecipientRelServiceImpl.updateById(upissueFailedAlarmRecipientRel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/issuefailedalarmrecipientrels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(issueFailedAlarmRecipientRelServiceImpl.removeById(id));
  }

  @PostMapping("/issuefailedalarmrecipientrels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "issue_failed_alarm_recipient_rel");
     params.put("request", condition);

     return XfR.ok(issueFailedAlarmRecipientRelServiceImpl.querys(params));
  }

}
