package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.IssuedFailedAlarmRuleChangedHistory;
import com.xforceplus.saasnotifierservice.service.IIssuedFailedAlarmRuleChangedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-09
 */
@RestController
public class IssuedFailedAlarmRuleChangedHistoryController {

  @Autowired
  private IIssuedFailedAlarmRuleChangedHistoryService issuedFailedAlarmRuleChangedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param issuedFailedAlarmRuleChangedHistory ${table.comment}
   * @return
   */
  @GetMapping("/issuedfailedalarmrulechangedhistorys" )
  public XfR getIssuedFailedAlarmRuleChangedHistorys(XfPage page, IssuedFailedAlarmRuleChangedHistory issuedFailedAlarmRuleChangedHistory) {
    return XfR.ok(issuedFailedAlarmRuleChangedHistoryServiceImpl.page(page, Wrappers.query(issuedFailedAlarmRuleChangedHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/issuedfailedalarmrulechangedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(issuedFailedAlarmRuleChangedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param issuedFailedAlarmRuleChangedHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/issuedfailedalarmrulechangedhistorys")
  public XfR save(@RequestBody IssuedFailedAlarmRuleChangedHistory issuedFailedAlarmRuleChangedHistory) {
     return XfR.ok(issuedFailedAlarmRuleChangedHistoryServiceImpl.save(issuedFailedAlarmRuleChangedHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param issuedFailedAlarmRuleChangedHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/issuedfailedalarmrulechangedhistorys/{id}")
  public XfR putUpdate(@RequestBody IssuedFailedAlarmRuleChangedHistory issuedFailedAlarmRuleChangedHistory,@PathVariable Long id) {
      issuedFailedAlarmRuleChangedHistory.setId(id);
      return XfR.ok(issuedFailedAlarmRuleChangedHistoryServiceImpl.updateById(issuedFailedAlarmRuleChangedHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param issuedFailedAlarmRuleChangedHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/issuedfailedalarmrulechangedhistorys/{id}")
  public XfR patchUpdate(@RequestBody IssuedFailedAlarmRuleChangedHistory issuedFailedAlarmRuleChangedHistory,@PathVariable Long id) {
      IssuedFailedAlarmRuleChangedHistory upissuedFailedAlarmRuleChangedHistory = issuedFailedAlarmRuleChangedHistoryServiceImpl.getById(id);
      if(upissuedFailedAlarmRuleChangedHistory != null){
        upissuedFailedAlarmRuleChangedHistory = ObjectCopyUtils.copyProperties(issuedFailedAlarmRuleChangedHistory,upissuedFailedAlarmRuleChangedHistory,true);
      }
      return XfR.ok(issuedFailedAlarmRuleChangedHistoryServiceImpl.updateById(upissuedFailedAlarmRuleChangedHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/issuedfailedalarmrulechangedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(issuedFailedAlarmRuleChangedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/issuedfailedalarmrulechangedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "issued_failed_alarm_rule_changed_history");
     params.put("request", condition);

     return XfR.ok(issuedFailedAlarmRuleChangedHistoryServiceImpl.querys(params));
  }

}
