package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.RedLetterConfirmationBindRule;
import com.xforceplus.saasnotifierservice.service.IRedLetterConfirmationBindRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-09
 */
@RestController
public class RedLetterConfirmationBindRuleController {

  @Autowired
  private IRedLetterConfirmationBindRuleService redLetterConfirmationBindRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetterConfirmationBindRule ${table.comment}
   * @return
   */
  @GetMapping("/redletterconfirmationbindrules" )
  public XfR getRedLetterConfirmationBindRules(XfPage page, RedLetterConfirmationBindRule redLetterConfirmationBindRule) {
    return XfR.ok(redLetterConfirmationBindRuleServiceImpl.page(page, Wrappers.query(redLetterConfirmationBindRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletterconfirmationbindrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLetterConfirmationBindRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetterConfirmationBindRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletterconfirmationbindrules")
  public XfR save(@RequestBody RedLetterConfirmationBindRule redLetterConfirmationBindRule) {
     return XfR.ok(redLetterConfirmationBindRuleServiceImpl.save(redLetterConfirmationBindRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetterConfirmationBindRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletterconfirmationbindrules/{id}")
  public XfR putUpdate(@RequestBody RedLetterConfirmationBindRule redLetterConfirmationBindRule,@PathVariable Long id) {
      redLetterConfirmationBindRule.setId(id);
      return XfR.ok(redLetterConfirmationBindRuleServiceImpl.updateById(redLetterConfirmationBindRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetterConfirmationBindRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletterconfirmationbindrules/{id}")
  public XfR patchUpdate(@RequestBody RedLetterConfirmationBindRule redLetterConfirmationBindRule,@PathVariable Long id) {
      RedLetterConfirmationBindRule upredLetterConfirmationBindRule = redLetterConfirmationBindRuleServiceImpl.getById(id);
      if(upredLetterConfirmationBindRule != null){
        upredLetterConfirmationBindRule = ObjectCopyUtils.copyProperties(redLetterConfirmationBindRule,upredLetterConfirmationBindRule,true);
      }
      return XfR.ok(redLetterConfirmationBindRuleServiceImpl.updateById(upredLetterConfirmationBindRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletterconfirmationbindrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLetterConfirmationBindRuleServiceImpl.removeById(id));
  }

  @PostMapping("/redletterconfirmationbindrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letter_confirmation_bind_rule");
     params.put("request", condition);

     return XfR.ok(redLetterConfirmationBindRuleServiceImpl.querys(params));
  }

}
