package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.ExceptionInvoice;
import com.xforceplus.saasnotifierservice.service.IExceptionInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class ExceptionInvoiceController {

  @Autowired
  private IExceptionInvoiceService exceptionInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exceptionInvoice ${table.comment}
   * @return
   */
  @GetMapping("/exceptioninvoices" )
  public XfR getExceptionInvoices(XfPage page, ExceptionInvoice exceptionInvoice) {
    return XfR.ok(exceptionInvoiceServiceImpl.page(page, Wrappers.query(exceptionInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/exceptioninvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exceptionInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param exceptionInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/exceptioninvoices")
  public XfR save(@RequestBody ExceptionInvoice exceptionInvoice) {
     return XfR.ok(exceptionInvoiceServiceImpl.save(exceptionInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param exceptionInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/exceptioninvoices/{id}")
  public XfR putUpdate(@RequestBody ExceptionInvoice exceptionInvoice,@PathVariable Long id) {
      exceptionInvoice.setId(id);
      return XfR.ok(exceptionInvoiceServiceImpl.updateById(exceptionInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param exceptionInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/exceptioninvoices/{id}")
  public XfR patchUpdate(@RequestBody ExceptionInvoice exceptionInvoice,@PathVariable Long id) {
      ExceptionInvoice upexceptionInvoice = exceptionInvoiceServiceImpl.getById(id);
      if(upexceptionInvoice != null){
        upexceptionInvoice = ObjectCopyUtils.copyProperties(exceptionInvoice,upexceptionInvoice,true);
      }
      return XfR.ok(exceptionInvoiceServiceImpl.updateById(upexceptionInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exceptioninvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exceptionInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/exceptioninvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "exception_invoice");
     params.put("request", condition);

     return XfR.ok(exceptionInvoiceServiceImpl.querys(params));
  }

}
