package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.TotalAmountWarningRule;
import com.xforceplus.saasnotifierservice.service.ITotalAmountWarningRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class TotalAmountWarningRuleController {

  @Autowired
  private ITotalAmountWarningRuleService totalAmountWarningRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param totalAmountWarningRule ${table.comment}
   * @return
   */
  @GetMapping("/totalamountwarningrules" )
  public XfR getTotalAmountWarningRules(XfPage page, TotalAmountWarningRule totalAmountWarningRule) {
    return XfR.ok(totalAmountWarningRuleServiceImpl.page(page, Wrappers.query(totalAmountWarningRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/totalamountwarningrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(totalAmountWarningRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param totalAmountWarningRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/totalamountwarningrules")
  public XfR save(@RequestBody TotalAmountWarningRule totalAmountWarningRule) {
     return XfR.ok(totalAmountWarningRuleServiceImpl.save(totalAmountWarningRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param totalAmountWarningRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/totalamountwarningrules/{id}")
  public XfR putUpdate(@RequestBody TotalAmountWarningRule totalAmountWarningRule,@PathVariable Long id) {
      totalAmountWarningRule.setId(id);
      return XfR.ok(totalAmountWarningRuleServiceImpl.updateById(totalAmountWarningRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param totalAmountWarningRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/totalamountwarningrules/{id}")
  public XfR patchUpdate(@RequestBody TotalAmountWarningRule totalAmountWarningRule,@PathVariable Long id) {
      TotalAmountWarningRule uptotalAmountWarningRule = totalAmountWarningRuleServiceImpl.getById(id);
      if(uptotalAmountWarningRule != null){
        uptotalAmountWarningRule = ObjectCopyUtils.copyProperties(totalAmountWarningRule,uptotalAmountWarningRule,true);
      }
      return XfR.ok(totalAmountWarningRuleServiceImpl.updateById(uptotalAmountWarningRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/totalamountwarningrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(totalAmountWarningRuleServiceImpl.removeById(id));
  }

  @PostMapping("/totalamountwarningrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "total_amount_warning_rule");
     params.put("request", condition);

     return XfR.ok(totalAmountWarningRuleServiceImpl.querys(params));
  }

}
