package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.TotalAmountWarningRuleHistory;
import com.xforceplus.saasnotifierservice.service.ITotalAmountWarningRuleHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class TotalAmountWarningRuleHistoryController {

  @Autowired
  private ITotalAmountWarningRuleHistoryService totalAmountWarningRuleHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param totalAmountWarningRuleHistory ${table.comment}
   * @return
   */
  @GetMapping("/totalamountwarningrulehistorys" )
  public XfR getTotalAmountWarningRuleHistorys(XfPage page, TotalAmountWarningRuleHistory totalAmountWarningRuleHistory) {
    return XfR.ok(totalAmountWarningRuleHistoryServiceImpl.page(page, Wrappers.query(totalAmountWarningRuleHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/totalamountwarningrulehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(totalAmountWarningRuleHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param totalAmountWarningRuleHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/totalamountwarningrulehistorys")
  public XfR save(@RequestBody TotalAmountWarningRuleHistory totalAmountWarningRuleHistory) {
     return XfR.ok(totalAmountWarningRuleHistoryServiceImpl.save(totalAmountWarningRuleHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param totalAmountWarningRuleHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/totalamountwarningrulehistorys/{id}")
  public XfR putUpdate(@RequestBody TotalAmountWarningRuleHistory totalAmountWarningRuleHistory,@PathVariable Long id) {
      totalAmountWarningRuleHistory.setId(id);
      return XfR.ok(totalAmountWarningRuleHistoryServiceImpl.updateById(totalAmountWarningRuleHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param totalAmountWarningRuleHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/totalamountwarningrulehistorys/{id}")
  public XfR patchUpdate(@RequestBody TotalAmountWarningRuleHistory totalAmountWarningRuleHistory,@PathVariable Long id) {
      TotalAmountWarningRuleHistory uptotalAmountWarningRuleHistory = totalAmountWarningRuleHistoryServiceImpl.getById(id);
      if(uptotalAmountWarningRuleHistory != null){
        uptotalAmountWarningRuleHistory = ObjectCopyUtils.copyProperties(totalAmountWarningRuleHistory,uptotalAmountWarningRuleHistory,true);
      }
      return XfR.ok(totalAmountWarningRuleHistoryServiceImpl.updateById(uptotalAmountWarningRuleHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/totalamountwarningrulehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(totalAmountWarningRuleHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/totalamountwarningrulehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "total_amount_warning_rule_history");
     params.put("request", condition);

     return XfR.ok(totalAmountWarningRuleHistoryServiceImpl.querys(params));
  }

}
