package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.WxNoticeBlackList;
import com.xforceplus.saasnotifierservice.service.IWxNoticeBlackListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-18
 */
@RestController
public class WxNoticeBlackListController {

  @Autowired
  private IWxNoticeBlackListService wxNoticeBlackListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param wxNoticeBlackList ${table.comment}
   * @return
   */
  @GetMapping("/wxnoticeblacklists" )
  public XfR getWxNoticeBlackLists(XfPage page, WxNoticeBlackList wxNoticeBlackList) {
    return XfR.ok(wxNoticeBlackListServiceImpl.page(page, Wrappers.query(wxNoticeBlackList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/wxnoticeblacklists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(wxNoticeBlackListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param wxNoticeBlackList ${table.comment}
   * @return XfR
   */
  @PostMapping("/wxnoticeblacklists")
  public XfR save(@RequestBody WxNoticeBlackList wxNoticeBlackList) {
     return XfR.ok(wxNoticeBlackListServiceImpl.save(wxNoticeBlackList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param wxNoticeBlackList ${table.comment}
   * @return XfR
   */
  @PutMapping("/wxnoticeblacklists/{id}")
  public XfR putUpdate(@RequestBody WxNoticeBlackList wxNoticeBlackList,@PathVariable Long id) {
      wxNoticeBlackList.setId(id);
      return XfR.ok(wxNoticeBlackListServiceImpl.updateById(wxNoticeBlackList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param wxNoticeBlackList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/wxnoticeblacklists/{id}")
  public XfR patchUpdate(@RequestBody WxNoticeBlackList wxNoticeBlackList,@PathVariable Long id) {
      WxNoticeBlackList upwxNoticeBlackList = wxNoticeBlackListServiceImpl.getById(id);
      if(upwxNoticeBlackList != null){
        upwxNoticeBlackList = ObjectCopyUtils.copyProperties(wxNoticeBlackList,upwxNoticeBlackList,true);
      }
      return XfR.ok(wxNoticeBlackListServiceImpl.updateById(upwxNoticeBlackList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/wxnoticeblacklists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(wxNoticeBlackListServiceImpl.removeById(id));
  }

  @PostMapping("/wxnoticeblacklists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "wx_notice_black_list");
     params.put("request", condition);

     return XfR.ok(wxNoticeBlackListServiceImpl.querys(params));
  }

}
