package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.CreditLimitWarningRule;
import com.xforceplus.saasnotifierservice.service.ICreditLimitWarningRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-25
 */
@RestController
public class CreditLimitWarningRuleController {

  @Autowired
  private ICreditLimitWarningRuleService creditLimitWarningRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param creditLimitWarningRule ${table.comment}
   * @return
   */
  @GetMapping("/creditlimitwarningrules" )
  public XfR getCreditLimitWarningRules(XfPage page, CreditLimitWarningRule creditLimitWarningRule) {
    return XfR.ok(creditLimitWarningRuleServiceImpl.page(page, Wrappers.query(creditLimitWarningRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/creditlimitwarningrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(creditLimitWarningRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param creditLimitWarningRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/creditlimitwarningrules")
  public XfR save(@RequestBody CreditLimitWarningRule creditLimitWarningRule) {
     return XfR.ok(creditLimitWarningRuleServiceImpl.save(creditLimitWarningRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param creditLimitWarningRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/creditlimitwarningrules/{id}")
  public XfR putUpdate(@RequestBody CreditLimitWarningRule creditLimitWarningRule,@PathVariable Long id) {
      creditLimitWarningRule.setId(id);
      return XfR.ok(creditLimitWarningRuleServiceImpl.updateById(creditLimitWarningRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param creditLimitWarningRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/creditlimitwarningrules/{id}")
  public XfR patchUpdate(@RequestBody CreditLimitWarningRule creditLimitWarningRule,@PathVariable Long id) {
      CreditLimitWarningRule upcreditLimitWarningRule = creditLimitWarningRuleServiceImpl.getById(id);
      if(upcreditLimitWarningRule != null){
        upcreditLimitWarningRule = ObjectCopyUtils.copyProperties(creditLimitWarningRule,upcreditLimitWarningRule,true);
      }
      return XfR.ok(creditLimitWarningRuleServiceImpl.updateById(upcreditLimitWarningRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/creditlimitwarningrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(creditLimitWarningRuleServiceImpl.removeById(id));
  }

  @PostMapping("/creditlimitwarningrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "credit_limit_warning_rule");
     params.put("request", condition);

     return XfR.ok(creditLimitWarningRuleServiceImpl.querys(params));
  }

}
