package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.CreditLimitWarningRuleHistory;
import com.xforceplus.saasnotifierservice.service.ICreditLimitWarningRuleHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-25
 */
@RestController
public class CreditLimitWarningRuleHistoryController {

  @Autowired
  private ICreditLimitWarningRuleHistoryService creditLimitWarningRuleHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param creditLimitWarningRuleHistory ${table.comment}
   * @return
   */
  @GetMapping("/creditlimitwarningrulehistorys" )
  public XfR getCreditLimitWarningRuleHistorys(XfPage page, CreditLimitWarningRuleHistory creditLimitWarningRuleHistory) {
    return XfR.ok(creditLimitWarningRuleHistoryServiceImpl.page(page, Wrappers.query(creditLimitWarningRuleHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/creditlimitwarningrulehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(creditLimitWarningRuleHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param creditLimitWarningRuleHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/creditlimitwarningrulehistorys")
  public XfR save(@RequestBody CreditLimitWarningRuleHistory creditLimitWarningRuleHistory) {
     return XfR.ok(creditLimitWarningRuleHistoryServiceImpl.save(creditLimitWarningRuleHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param creditLimitWarningRuleHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/creditlimitwarningrulehistorys/{id}")
  public XfR putUpdate(@RequestBody CreditLimitWarningRuleHistory creditLimitWarningRuleHistory,@PathVariable Long id) {
      creditLimitWarningRuleHistory.setId(id);
      return XfR.ok(creditLimitWarningRuleHistoryServiceImpl.updateById(creditLimitWarningRuleHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param creditLimitWarningRuleHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/creditlimitwarningrulehistorys/{id}")
  public XfR patchUpdate(@RequestBody CreditLimitWarningRuleHistory creditLimitWarningRuleHistory,@PathVariable Long id) {
      CreditLimitWarningRuleHistory upcreditLimitWarningRuleHistory = creditLimitWarningRuleHistoryServiceImpl.getById(id);
      if(upcreditLimitWarningRuleHistory != null){
        upcreditLimitWarningRuleHistory = ObjectCopyUtils.copyProperties(creditLimitWarningRuleHistory,upcreditLimitWarningRuleHistory,true);
      }
      return XfR.ok(creditLimitWarningRuleHistoryServiceImpl.updateById(upcreditLimitWarningRuleHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/creditlimitwarningrulehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(creditLimitWarningRuleHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/creditlimitwarningrulehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "credit_limit_warning_rule_history");
     params.put("request", condition);

     return XfR.ok(creditLimitWarningRuleHistoryServiceImpl.querys(params));
  }

}
