package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.OnboardNotifyHistory;
import com.xforceplus.saasnotifierservice.service.IOnboardNotifyHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-25
 */
@RestController
public class OnboardNotifyHistoryController {

  @Autowired
  private IOnboardNotifyHistoryService onboardNotifyHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param onboardNotifyHistory ${table.comment}
   * @return
   */
  @GetMapping("/onboardnotifyhistorys" )
  public XfR getOnboardNotifyHistorys(XfPage page, OnboardNotifyHistory onboardNotifyHistory) {
    return XfR.ok(onboardNotifyHistoryServiceImpl.page(page, Wrappers.query(onboardNotifyHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/onboardnotifyhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(onboardNotifyHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param onboardNotifyHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/onboardnotifyhistorys")
  public XfR save(@RequestBody OnboardNotifyHistory onboardNotifyHistory) {
     return XfR.ok(onboardNotifyHistoryServiceImpl.save(onboardNotifyHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param onboardNotifyHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/onboardnotifyhistorys/{id}")
  public XfR putUpdate(@RequestBody OnboardNotifyHistory onboardNotifyHistory,@PathVariable Long id) {
      onboardNotifyHistory.setId(id);
      return XfR.ok(onboardNotifyHistoryServiceImpl.updateById(onboardNotifyHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param onboardNotifyHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/onboardnotifyhistorys/{id}")
  public XfR patchUpdate(@RequestBody OnboardNotifyHistory onboardNotifyHistory,@PathVariable Long id) {
      OnboardNotifyHistory uponboardNotifyHistory = onboardNotifyHistoryServiceImpl.getById(id);
      if(uponboardNotifyHistory != null){
        uponboardNotifyHistory = ObjectCopyUtils.copyProperties(onboardNotifyHistory,uponboardNotifyHistory,true);
      }
      return XfR.ok(onboardNotifyHistoryServiceImpl.updateById(uponboardNotifyHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/onboardnotifyhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(onboardNotifyHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/onboardnotifyhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "onboard_notify_history");
     params.put("request", condition);

     return XfR.ok(onboardNotifyHistoryServiceImpl.querys(params));
  }

}
