package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.Org;
import com.xforceplus.saasnotifierservice.service.IOrgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-25
 */
@RestController
public class OrgController {

  @Autowired
  private IOrgService orgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param org ${table.comment}
   * @return
   */
  @GetMapping("/orgs" )
  public XfR getOrgs(XfPage page, Org org) {
    return XfR.ok(orgServiceImpl.page(page, Wrappers.query(org)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orgServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param org ${table.comment}
   * @return XfR
   */
  @PostMapping("/orgs")
  public XfR save(@RequestBody Org org) {
     return XfR.ok(orgServiceImpl.save(org));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param org ${table.comment}
   * @return XfR
   */
  @PutMapping("/orgs/{id}")
  public XfR putUpdate(@RequestBody Org org,@PathVariable Long id) {
      org.setId(id);
      return XfR.ok(orgServiceImpl.updateById(org));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param org ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orgs/{id}")
  public XfR patchUpdate(@RequestBody Org org,@PathVariable Long id) {
      Org uporg = orgServiceImpl.getById(id);
      if(uporg != null){
        uporg = ObjectCopyUtils.copyProperties(org,uporg,true);
      }
      return XfR.ok(orgServiceImpl.updateById(uporg));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orgServiceImpl.removeById(id));
  }

  @PostMapping("/orgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "org");
     params.put("request", condition);

     return XfR.ok(orgServiceImpl.querys(params));
  }

}
