package com.xforceplus.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.saasnotifierservice.entity.RiskWarningRule;
import com.xforceplus.saasnotifierservice.service.IRiskWarningRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 风险预警规则前端控制器
 *
 * @author ultraman
 * @date 2024-11-25
 */
@RestController
public class RiskWarningRuleController {

  @Autowired
  private IRiskWarningRuleService riskWarningRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param riskWarningRule 风险预警规则
   * @return
   */
  @GetMapping("/riskwarningrules" )
  public XfR getRiskWarningRules(XfPage page, RiskWarningRule riskWarningRule) {
    return XfR.ok(riskWarningRuleServiceImpl.page(page, Wrappers.query(riskWarningRule)));
  }

  /**
   * 通过id查询风险预警规则
   * @param  id
   * @return XfR
   */
  @GetMapping("/riskwarningrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(riskWarningRuleServiceImpl.getById(id));
  }

  /**
   * 新增风险预警规则
   * @param riskWarningRule 风险预警规则
   * @return XfR
   */
  @PostMapping("/riskwarningrules")
  public XfR save(@RequestBody RiskWarningRule riskWarningRule) {
     return XfR.ok(riskWarningRuleServiceImpl.save(riskWarningRule));
  }

  /**
   * 修改-传入修改后的全部数据风险预警规则
   * @param riskWarningRule 风险预警规则
   * @return XfR
   */
  @PutMapping("/riskwarningrules/{id}")
  public XfR putUpdate(@RequestBody RiskWarningRule riskWarningRule,@PathVariable Long id) {
      riskWarningRule.setId(id);
      return XfR.ok(riskWarningRuleServiceImpl.updateById(riskWarningRule));
  }

  /**
   * 修改-传入修改的数据风险预警规则
   * @param riskWarningRule 风险预警规则
   * @return XfR
   */
  @PatchMapping("/riskwarningrules/{id}")
  public XfR patchUpdate(@RequestBody RiskWarningRule riskWarningRule,@PathVariable Long id) {
      RiskWarningRule upriskWarningRule = riskWarningRuleServiceImpl.getById(id);
      if(upriskWarningRule != null){
        upriskWarningRule = ObjectCopyUtils.copyProperties(riskWarningRule,upriskWarningRule,true);
      }
      return XfR.ok(riskWarningRuleServiceImpl.updateById(upriskWarningRule));
  }

  /**
   * 通过id删除风险预警规则
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/riskwarningrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(riskWarningRuleServiceImpl.removeById(id));
  }

  @PostMapping("/riskwarningrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "risk_warning_rule");
     params.put("request", condition);

     return XfR.ok(riskWarningRuleServiceImpl.querys(params));
  }

}
