package com.xforceplus.sdktest.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-05-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.C1Person;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "sdk-test")
public interface C1PersonFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/c1Person/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param c1Person ${table.comment}
   * @return R
   */
  @PostMapping("/c1Person/add")
  public R save(@RequestBody C1Person c1Person);

  /**
   * 修改${table.comment}
   * @param c1Person ${table.comment}
   * @return R
   */
  @PostMapping("/c1Person/update")
  public R updateById(@RequestBody C1Person c1Person);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/c1Person/del/{id}" )
  public R removeById(@PathVariable Long id);

}