package com.xforceplus.sdktest.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-05-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.FormulaEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "sdk-test")
public interface FormulaEntityFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/formulaEntity/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param formulaEntity ${table.comment}
   * @return R
   */
  @PostMapping("/formulaEntity/add")
  public R save(@RequestBody FormulaEntity formulaEntity);

  /**
   * 修改${table.comment}
   * @param formulaEntity ${table.comment}
   * @return R
   */
  @PostMapping("/formulaEntity/update")
  public R updateById(@RequestBody FormulaEntity formulaEntity);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/formulaEntity/del/{id}" )
  public R removeById(@PathVariable Long id);

}