package com.xforceplus.sdktest.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-05-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.App;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "sdk-test")
public interface AppFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/app/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param app ${table.comment}
   * @return R
   */
  @PostMapping("/app/add")
  public R save(@RequestBody App app);

  /**
   * 修改${table.comment}
   * @param app ${table.comment}
   * @return R
   */
  @PostMapping("/app/update")
  public R updateById(@RequestBody App app);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/app/del/{id}" )
  public R removeById(@PathVariable Long id);

}