package com.xforceplus.sdktest.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-06-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.AppLevel4;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "sdk-test")
public interface AppLevel4FeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/appLevel4/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param appLevel4 ${table.comment}
   * @return R
   */
  @PostMapping("/appLevel4/add")
  public R save(@RequestBody AppLevel4 appLevel4);

  /**
   * 修改${table.comment}
   * @param appLevel4 ${table.comment}
   * @return R
   */
  @PostMapping("/appLevel4/update")
  public R updateById(@RequestBody AppLevel4 appLevel4);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/appLevel4/del/{id}" )
  public R removeById(@PathVariable Long id);

}