package com.xforceplus.sdktest.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 性别
 * </p>
 *
 * @author ultraman
 * @since 2021-05-11
 */
public enum Sex {

    M("m", "男"),
    F("f", "女");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Sex(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Sex fromCode(String code){
        switch(code) {
            case "m":
                return M;
            case "f":
                return F;
            default:
                return null;
        }
    }
}
