package com.xforceplus.sdktest.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ActionTrail implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("userName")
  private String userName;

  @TableField("eventTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime eventTime;

  @TableField("eventType")
  private String eventType;

  @TableField("requestId")
  private String requestId;

  @TableField("httpMethod")
  private String httpMethod;

  private String uri;

  private String ip;

  @TableField("userInfo")
  private String userInfo;

  @TableField("requestBody")
  private String requestBody;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("userName", userName);
      map.put("eventTime", BocpGenUtils.toTimestamp(eventTime));
      map.put("eventType", eventType);
      map.put("requestId", requestId);
      map.put("httpMethod", httpMethod);
      map.put("uri", uri);
      map.put("ip", ip);
      map.put("userInfo", userInfo);
      map.put("requestBody", requestBody);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ActionTrail fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    ActionTrail entity = new ActionTrail();
    if(map.containsKey("userName")) {
      Object obj = map.get("userName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eventTime")) {
      Object obj = map.get("eventTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEventTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEventTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEventTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEventTime(null);
      }
    }
    if(map.containsKey("eventType")) {
      Object obj = map.get("eventType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEventType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestId")) {
      Object obj = map.get("requestId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("httpMethod")) {
      Object obj = map.get("httpMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHttpMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uri")) {
      Object obj = map.get("uri");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUri((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ip")) {
      Object obj = map.get("ip");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userInfo")) {
      Object obj = map.get("userInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestBody")) {
      Object obj = map.get("requestBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
