package com.xforceplus.sdktest.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.sdktest.entity.ChildTest;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChildTest3 extends ChildTest {


  private String level3;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("level3", level3);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ChildTest3 fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    ChildTest3 entity = new ChildTest3();
    if(map.containsKey("fieldstr")) {
      Object obj = map.get("fieldstr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFieldstr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fieldbool")) {
      Object obj = map.get("fieldbool");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFieldbool((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setFieldbool(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("fieldlong")) {
      Object obj = map.get("fieldlong");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFieldlong((Long)obj);
        } else if(obj instanceof String) {
          entity.setFieldlong(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFieldlong(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("fieldserial")) {
      Object obj = map.get("fieldserial");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFieldserial((Long)obj);
        } else if(obj instanceof String) {
          entity.setFieldserial(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setFieldserial(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("fieldenum")) {
      Object obj = map.get("fieldenum");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFieldenum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fieldtime")) {
      Object obj = map.get("fieldtime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFieldtime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFieldtime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setFieldtime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setFieldtime(null);
      }
    }
    if(map.containsKey("fielddouble")) {
      Object obj = map.get("fielddouble");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFielddouble((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFielddouble(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFielddouble(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFielddouble(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFielddouble(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("fieldstrs")) {
      Object obj = map.get("fieldstrs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFieldstrs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("level3")) {
      Object obj = map.get("level3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLevel3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
