package com.xforceplus.sdktest.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.sdktest.entity.Assets;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Assetchild extends Assets {


  private String testCode;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("test_code", testCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Assetchild fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    Assetchild entity = new Assetchild();
    if(map.containsKey("asset_no")) {
      Object obj = map.get("asset_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssetNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amout")) {
      Object obj = map.get("amout");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmout((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmout(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmout(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmout(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmout(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("mortage_start_date")) {
      Object obj = map.get("mortage_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMortageStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMortageStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setMortageStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setMortageStartDate(null);
      }
    }
    if(map.containsKey("pay_date")) {
      Object obj = map.get("pay_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPayDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setPayDate(null);
      }
    }
    if(map.containsKey("already_amout")) {
      Object obj = map.get("already_amout");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyAmout((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyAmout(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyAmout(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAlreadyAmout(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyAmout(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("aprrove_status")) {
      Object obj = map.get("aprrove_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAprroveStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("search_status")) {
      Object obj = map.get("search_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSearchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("repay_status")) {
      Object obj = map.get("repay_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRepayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("test_code")) {
      Object obj = map.get("test_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTestCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
