package com.xforceplus.sdktest.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 资产查询状态
 * </p>
 *
 * @author ultraman
 * @since 2021-06-13
 */
public enum SearchStatus {

    _2("2", "待审核"),
    _1("1", "待放款"),
    _3("3", "已放款"),
    _4("4", "已退回"),
    _0("0", "全部");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SearchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SearchStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "1":
                return _1;
            case "3":
                return _3;
            case "4":
                return _4;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
