package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.A;
import com.xforceplus.seanapp.service.IAService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-20
 */
@RestController
public class AController {

  @Autowired
  private IAService AServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param a ${table.comment}
   * @return
   */
  @GetMapping("/as" )
  public XfR getAs(XfPage page, A a) {
    return XfR.ok(AServiceImpl.page(page, Wrappers.query(a)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/as/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(AServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param a ${table.comment}
   * @return XfR
   */
  @PostMapping("/as")
  public XfR save(@RequestBody A a) {
     return XfR.ok(AServiceImpl.save(a));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param a ${table.comment}
   * @return XfR
   */
  @PutMapping("/as/{id}")
  public XfR putUpdate(@RequestBody A a,@PathVariable Long id) {
      a.setId(id);
      return XfR.ok(AServiceImpl.updateById(a));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param a ${table.comment}
   * @return XfR
   */
  @PatchMapping("/as/{id}")
  public XfR patchUpdate(@RequestBody A a,@PathVariable Long id) {
      A upa = AServiceImpl.getById(id);
      if(upa != null){
        upa = ObjectCopyUtils.copyProperties(a,upa,true);
      }
      return XfR.ok(AServiceImpl.updateById(upa));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/as/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(AServiceImpl.removeById(id));
  }

  @PostMapping("/as/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "a");
     params.put("request", condition);

     return XfR.ok(AServiceImpl.querys(params));
  }

}
