package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.B;
import com.xforceplus.seanapp.service.IBService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-20
 */
@RestController
public class BController {

  @Autowired
  private IBService BServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param b ${table.comment}
   * @return
   */
  @GetMapping("/bs" )
  public XfR getBs(XfPage page, B b) {
    return XfR.ok(BServiceImpl.page(page, Wrappers.query(b)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(BServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param b ${table.comment}
   * @return XfR
   */
  @PostMapping("/bs")
  public XfR save(@RequestBody B b) {
     return XfR.ok(BServiceImpl.save(b));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param b ${table.comment}
   * @return XfR
   */
  @PutMapping("/bs/{id}")
  public XfR putUpdate(@RequestBody B b,@PathVariable Long id) {
      b.setId(id);
      return XfR.ok(BServiceImpl.updateById(b));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param b ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bs/{id}")
  public XfR patchUpdate(@RequestBody B b,@PathVariable Long id) {
      B upb = BServiceImpl.getById(id);
      if(upb != null){
        upb = ObjectCopyUtils.copyProperties(b,upb,true);
      }
      return XfR.ok(BServiceImpl.updateById(upb));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(BServiceImpl.removeById(id));
  }

  @PostMapping("/bs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "b");
     params.put("request", condition);

     return XfR.ok(BServiceImpl.querys(params));
  }

}
