package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.C;
import com.xforceplus.seanapp.service.ICService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-20
 */
@RestController
public class CController {

  @Autowired
  private ICService CServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param c ${table.comment}
   * @return
   */
  @GetMapping("/cs" )
  public XfR getCs(XfPage page, C c) {
    return XfR.ok(CServiceImpl.page(page, Wrappers.query(c)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/cs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(CServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param c ${table.comment}
   * @return XfR
   */
  @PostMapping("/cs")
  public XfR save(@RequestBody C c) {
     return XfR.ok(CServiceImpl.save(c));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param c ${table.comment}
   * @return XfR
   */
  @PutMapping("/cs/{id}")
  public XfR putUpdate(@RequestBody C c,@PathVariable Long id) {
      c.setId(id);
      return XfR.ok(CServiceImpl.updateById(c));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param c ${table.comment}
   * @return XfR
   */
  @PatchMapping("/cs/{id}")
  public XfR patchUpdate(@RequestBody C c,@PathVariable Long id) {
      C upc = CServiceImpl.getById(id);
      if(upc != null){
        upc = ObjectCopyUtils.copyProperties(c,upc,true);
      }
      return XfR.ok(CServiceImpl.updateById(upc));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(CServiceImpl.removeById(id));
  }

  @PostMapping("/cs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "c");
     params.put("request", condition);

     return XfR.ok(CServiceImpl.querys(params));
  }

}
