package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.D;
import com.xforceplus.seanapp.service.IDService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-20
 */
@RestController
public class DController {

  @Autowired
  private IDService DServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param d ${table.comment}
   * @return
   */
  @GetMapping("/ds" )
  public XfR getDs(XfPage page, D d) {
    return XfR.ok(DServiceImpl.page(page, Wrappers.query(d)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(DServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param d ${table.comment}
   * @return XfR
   */
  @PostMapping("/ds")
  public XfR save(@RequestBody D d) {
     return XfR.ok(DServiceImpl.save(d));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param d ${table.comment}
   * @return XfR
   */
  @PutMapping("/ds/{id}")
  public XfR putUpdate(@RequestBody D d,@PathVariable Long id) {
      d.setId(id);
      return XfR.ok(DServiceImpl.updateById(d));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param d ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ds/{id}")
  public XfR patchUpdate(@RequestBody D d,@PathVariable Long id) {
      D upd = DServiceImpl.getById(id);
      if(upd != null){
        upd = ObjectCopyUtils.copyProperties(d,upd,true);
      }
      return XfR.ok(DServiceImpl.updateById(upd));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(DServiceImpl.removeById(id));
  }

  @PostMapping("/ds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "d");
     params.put("request", condition);

     return XfR.ok(DServiceImpl.querys(params));
  }

}
