package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Fulei;
import com.xforceplus.seanapp.service.IFuleiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-20
 */
@RestController
public class FuleiController {

  @Autowired
  private IFuleiService fuleiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fulei ${table.comment}
   * @return
   */
  @GetMapping("/fuleis" )
  public XfR getFuleis(XfPage page, Fulei fulei) {
    return XfR.ok(fuleiServiceImpl.page(page, Wrappers.query(fulei)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fuleis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fuleiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fulei ${table.comment}
   * @return XfR
   */
  @PostMapping("/fuleis")
  public XfR save(@RequestBody Fulei fulei) {
     return XfR.ok(fuleiServiceImpl.save(fulei));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fulei ${table.comment}
   * @return XfR
   */
  @PutMapping("/fuleis/{id}")
  public XfR putUpdate(@RequestBody Fulei fulei,@PathVariable Long id) {
      fulei.setId(id);
      return XfR.ok(fuleiServiceImpl.updateById(fulei));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fulei ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fuleis/{id}")
  public XfR patchUpdate(@RequestBody Fulei fulei,@PathVariable Long id) {
      Fulei upfulei = fuleiServiceImpl.getById(id);
      if(upfulei != null){
        upfulei = ObjectCopyUtils.copyProperties(fulei,upfulei,true);
      }
      return XfR.ok(fuleiServiceImpl.updateById(upfulei));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fuleis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fuleiServiceImpl.removeById(id));
  }

  @PostMapping("/fuleis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fulei");
     params.put("request", condition);

     return XfR.ok(fuleiServiceImpl.querys(params));
  }

}
