package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Metome;
import com.xforceplus.seanapp.service.IMetomeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-20
 */
@RestController
public class MetomeController {

  @Autowired
  private IMetomeService metomeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param metome ${table.comment}
   * @return
   */
  @GetMapping("/metomes" )
  public XfR getMetomes(XfPage page, Metome metome) {
    return XfR.ok(metomeServiceImpl.page(page, Wrappers.query(metome)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/metomes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(metomeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param metome ${table.comment}
   * @return XfR
   */
  @PostMapping("/metomes")
  public XfR save(@RequestBody Metome metome) {
     return XfR.ok(metomeServiceImpl.save(metome));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param metome ${table.comment}
   * @return XfR
   */
  @PutMapping("/metomes/{id}")
  public XfR putUpdate(@RequestBody Metome metome,@PathVariable Long id) {
      metome.setId(id);
      return XfR.ok(metomeServiceImpl.updateById(metome));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param metome ${table.comment}
   * @return XfR
   */
  @PatchMapping("/metomes/{id}")
  public XfR patchUpdate(@RequestBody Metome metome,@PathVariable Long id) {
      Metome upmetome = metomeServiceImpl.getById(id);
      if(upmetome != null){
        upmetome = ObjectCopyUtils.copyProperties(metome,upmetome,true);
      }
      return XfR.ok(metomeServiceImpl.updateById(upmetome));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/metomes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(metomeServiceImpl.removeById(id));
  }

  @PostMapping("/metomes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "metome");
     params.put("request", condition);

     return XfR.ok(metomeServiceImpl.querys(params));
  }

}
