package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Fuleiguanlian;
import com.xforceplus.seanapp.service.IFuleiguanlianService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-21
 */
@RestController
public class FuleiguanlianController {

  @Autowired
  private IFuleiguanlianService fuleiguanlianServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fuleiguanlian ${table.comment}
   * @return
   */
  @GetMapping("/fuleiguanlians" )
  public XfR getFuleiguanlians(XfPage page, Fuleiguanlian fuleiguanlian) {
    return XfR.ok(fuleiguanlianServiceImpl.page(page, Wrappers.query(fuleiguanlian)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fuleiguanlians/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fuleiguanlianServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fuleiguanlian ${table.comment}
   * @return XfR
   */
  @PostMapping("/fuleiguanlians")
  public XfR save(@RequestBody Fuleiguanlian fuleiguanlian) {
     return XfR.ok(fuleiguanlianServiceImpl.save(fuleiguanlian));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fuleiguanlian ${table.comment}
   * @return XfR
   */
  @PutMapping("/fuleiguanlians/{id}")
  public XfR putUpdate(@RequestBody Fuleiguanlian fuleiguanlian,@PathVariable Long id) {
      fuleiguanlian.setId(id);
      return XfR.ok(fuleiguanlianServiceImpl.updateById(fuleiguanlian));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fuleiguanlian ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fuleiguanlians/{id}")
  public XfR patchUpdate(@RequestBody Fuleiguanlian fuleiguanlian,@PathVariable Long id) {
      Fuleiguanlian upfuleiguanlian = fuleiguanlianServiceImpl.getById(id);
      if(upfuleiguanlian != null){
        upfuleiguanlian = ObjectCopyUtils.copyProperties(fuleiguanlian,upfuleiguanlian,true);
      }
      return XfR.ok(fuleiguanlianServiceImpl.updateById(upfuleiguanlian));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fuleiguanlians/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fuleiguanlianServiceImpl.removeById(id));
  }

  @PostMapping("/fuleiguanlians/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fuleiguanlian");
     params.put("request", condition);

     return XfR.ok(fuleiguanlianServiceImpl.querys(params));
  }

}
