package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Invoicedetails;
import com.xforceplus.seanapp.service.IInvoicedetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-21
 */
@RestController
public class InvoicedetailsController {

  @Autowired
  private IInvoicedetailsService invoicedetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicedetails ${table.comment}
   * @return
   */
  @GetMapping("/invoicedetailss" )
  public XfR getInvoicedetailss(XfPage page, Invoicedetails invoicedetails) {
    return XfR.ok(invoicedetailsServiceImpl.page(page, Wrappers.query(invoicedetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicedetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoicedetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedetailss")
  public XfR save(@RequestBody Invoicedetails invoicedetails) {
     return XfR.ok(invoicedetailsServiceImpl.save(invoicedetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoicedetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedetailss/{id}")
  public XfR putUpdate(@RequestBody Invoicedetails invoicedetails,@PathVariable Long id) {
      invoicedetails.setId(id);
      return XfR.ok(invoicedetailsServiceImpl.updateById(invoicedetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoicedetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedetailss/{id}")
  public XfR patchUpdate(@RequestBody Invoicedetails invoicedetails,@PathVariable Long id) {
      Invoicedetails upinvoicedetails = invoicedetailsServiceImpl.getById(id);
      if(upinvoicedetails != null){
        upinvoicedetails = ObjectCopyUtils.copyProperties(invoicedetails,upinvoicedetails,true);
      }
      return XfR.ok(invoicedetailsServiceImpl.updateById(upinvoicedetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicedetailsServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoicedetails");
     params.put("request", condition);

     return XfR.ok(invoicedetailsServiceImpl.querys(params));
  }

}
