package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Largetrans;
import com.xforceplus.seanapp.service.ILargetransService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-21
 */
@RestController
public class LargetransController {

  @Autowired
  private ILargetransService largetransServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param largetrans ${table.comment}
   * @return
   */
  @GetMapping("/largetranss" )
  public XfR getLargetranss(XfPage page, Largetrans largetrans) {
    return XfR.ok(largetransServiceImpl.page(page, Wrappers.query(largetrans)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/largetranss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(largetransServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param largetrans ${table.comment}
   * @return XfR
   */
  @PostMapping("/largetranss")
  public XfR save(@RequestBody Largetrans largetrans) {
     return XfR.ok(largetransServiceImpl.save(largetrans));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param largetrans ${table.comment}
   * @return XfR
   */
  @PutMapping("/largetranss/{id}")
  public XfR putUpdate(@RequestBody Largetrans largetrans,@PathVariable Long id) {
      largetrans.setId(id);
      return XfR.ok(largetransServiceImpl.updateById(largetrans));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param largetrans ${table.comment}
   * @return XfR
   */
  @PatchMapping("/largetranss/{id}")
  public XfR patchUpdate(@RequestBody Largetrans largetrans,@PathVariable Long id) {
      Largetrans uplargetrans = largetransServiceImpl.getById(id);
      if(uplargetrans != null){
        uplargetrans = ObjectCopyUtils.copyProperties(largetrans,uplargetrans,true);
      }
      return XfR.ok(largetransServiceImpl.updateById(uplargetrans));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/largetranss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(largetransServiceImpl.removeById(id));
  }

  @PostMapping("/largetranss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "largetrans");
     params.put("request", condition);

     return XfR.ok(largetransServiceImpl.querys(params));
  }

}
