package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Mustfield;
import com.xforceplus.seanapp.service.IMustfieldService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-21
 */
@RestController
public class MustfieldController {

  @Autowired
  private IMustfieldService mustfieldServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mustfield ${table.comment}
   * @return
   */
  @GetMapping("/mustfields" )
  public XfR getMustfields(XfPage page, Mustfield mustfield) {
    return XfR.ok(mustfieldServiceImpl.page(page, Wrappers.query(mustfield)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/mustfields/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mustfieldServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param mustfield ${table.comment}
   * @return XfR
   */
  @PostMapping("/mustfields")
  public XfR save(@RequestBody Mustfield mustfield) {
     return XfR.ok(mustfieldServiceImpl.save(mustfield));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param mustfield ${table.comment}
   * @return XfR
   */
  @PutMapping("/mustfields/{id}")
  public XfR putUpdate(@RequestBody Mustfield mustfield,@PathVariable Long id) {
      mustfield.setId(id);
      return XfR.ok(mustfieldServiceImpl.updateById(mustfield));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param mustfield ${table.comment}
   * @return XfR
   */
  @PatchMapping("/mustfields/{id}")
  public XfR patchUpdate(@RequestBody Mustfield mustfield,@PathVariable Long id) {
      Mustfield upmustfield = mustfieldServiceImpl.getById(id);
      if(upmustfield != null){
        upmustfield = ObjectCopyUtils.copyProperties(mustfield,upmustfield,true);
      }
      return XfR.ok(mustfieldServiceImpl.updateById(upmustfield));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mustfields/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mustfieldServiceImpl.removeById(id));
  }

  @PostMapping("/mustfields/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mustfield");
     params.put("request", condition);

     return XfR.ok(mustfieldServiceImpl.querys(params));
  }

}
