package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Redinvocie;
import com.xforceplus.seanapp.service.IRedinvocieService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-21
 */
@RestController
public class RedinvocieController {

  @Autowired
  private IRedinvocieService redinvocieServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redinvocie ${table.comment}
   * @return
   */
  @GetMapping("/redinvocies" )
  public XfR getRedinvocies(XfPage page, Redinvocie redinvocie) {
    return XfR.ok(redinvocieServiceImpl.page(page, Wrappers.query(redinvocie)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redinvocies/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redinvocieServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redinvocie ${table.comment}
   * @return XfR
   */
  @PostMapping("/redinvocies")
  public XfR save(@RequestBody Redinvocie redinvocie) {
     return XfR.ok(redinvocieServiceImpl.save(redinvocie));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redinvocie ${table.comment}
   * @return XfR
   */
  @PutMapping("/redinvocies/{id}")
  public XfR putUpdate(@RequestBody Redinvocie redinvocie,@PathVariable Long id) {
      redinvocie.setId(id);
      return XfR.ok(redinvocieServiceImpl.updateById(redinvocie));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redinvocie ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redinvocies/{id}")
  public XfR patchUpdate(@RequestBody Redinvocie redinvocie,@PathVariable Long id) {
      Redinvocie upredinvocie = redinvocieServiceImpl.getById(id);
      if(upredinvocie != null){
        upredinvocie = ObjectCopyUtils.copyProperties(redinvocie,upredinvocie,true);
      }
      return XfR.ok(redinvocieServiceImpl.updateById(upredinvocie));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redinvocies/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redinvocieServiceImpl.removeById(id));
  }

  @PostMapping("/redinvocies/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "redinvocie");
     params.put("request", condition);

     return XfR.ok(redinvocieServiceImpl.querys(params));
  }

}
