package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Test0430;
import com.xforceplus.seanapp.service.ITest0430Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-21
 */
@RestController
public class Test0430Controller {

  @Autowired
  private ITest0430Service test0430ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0430 ${table.comment}
   * @return
   */
  @GetMapping("/test0430s" )
  public XfR getTest0430s(XfPage page, Test0430 test0430) {
    return XfR.ok(test0430ServiceImpl.page(page, Wrappers.query(test0430)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0430s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0430ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test0430 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test0430s")
  public XfR save(@RequestBody Test0430 test0430) {
     return XfR.ok(test0430ServiceImpl.save(test0430));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test0430 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test0430s/{id}")
  public XfR putUpdate(@RequestBody Test0430 test0430,@PathVariable Long id) {
      test0430.setId(id);
      return XfR.ok(test0430ServiceImpl.updateById(test0430));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test0430 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test0430s/{id}")
  public XfR patchUpdate(@RequestBody Test0430 test0430,@PathVariable Long id) {
      Test0430 uptest0430 = test0430ServiceImpl.getById(id);
      if(uptest0430 != null){
        uptest0430 = ObjectCopyUtils.copyProperties(test0430,uptest0430,true);
      }
      return XfR.ok(test0430ServiceImpl.updateById(uptest0430));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0430s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0430ServiceImpl.removeById(id));
  }

  @PostMapping("/test0430s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0430");
     params.put("request", condition);

     return XfR.ok(test0430ServiceImpl.querys(params));
  }

}
