package com.xforceplus.seanapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.seanapp.entity.Trans;
import com.xforceplus.seanapp.service.ITransService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-21
 */
@RestController
public class TransController {

  @Autowired
  private ITransService transServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param trans ${table.comment}
   * @return
   */
  @GetMapping("/transs" )
  public XfR getTranss(XfPage page, Trans trans) {
    return XfR.ok(transServiceImpl.page(page, Wrappers.query(trans)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/transs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(transServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param trans ${table.comment}
   * @return XfR
   */
  @PostMapping("/transs")
  public XfR save(@RequestBody Trans trans) {
     return XfR.ok(transServiceImpl.save(trans));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param trans ${table.comment}
   * @return XfR
   */
  @PutMapping("/transs/{id}")
  public XfR putUpdate(@RequestBody Trans trans,@PathVariable Long id) {
      trans.setId(id);
      return XfR.ok(transServiceImpl.updateById(trans));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param trans ${table.comment}
   * @return XfR
   */
  @PatchMapping("/transs/{id}")
  public XfR patchUpdate(@RequestBody Trans trans,@PathVariable Long id) {
      Trans uptrans = transServiceImpl.getById(id);
      if(uptrans != null){
        uptrans = ObjectCopyUtils.copyProperties(trans,uptrans,true);
      }
      return XfR.ok(transServiceImpl.updateById(uptrans));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/transs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(transServiceImpl.removeById(id));
  }

  @PostMapping("/transs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "trans");
     params.put("request", condition);

     return XfR.ok(transServiceImpl.querys(params));
  }

}
