package com.xforceplus.sdktest.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-03-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.ExtendedBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "skdBill")
public interface ExtendedBillFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/extendedBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param extendedBill ${table.comment}
   * @return R
   */
  @PostMapping("/extendedBill/add")
  public R save(@RequestBody ExtendedBill extendedBill);

  /**
   * 修改${table.comment}
   * @param extendedBill ${table.comment}
   * @return R
   */
  @PostMapping("/extendedBill/update")
  public R updateById(@RequestBody ExtendedBill extendedBill);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/extendedBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}