package com.xforceplus.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.ExtendedBill;
import com.xforceplus.sdktest.service.IExtendedBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-01
 */
@RestController
public class ExtendedBillController {

  @Autowired
  private IExtendedBillService extendedBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param extendedBill ${table.comment}
   * @return
   */
  @GetMapping("/extendedbills" )
  public XfR getExtendedBills(XfPage page, ExtendedBill extendedBill) {
    return XfR.ok(extendedBillServiceImpl.page(page, Wrappers.query(extendedBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/extendedbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(extendedBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param extendedBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/extendedbills")
  public XfR save(@RequestBody ExtendedBill extendedBill) {
     return XfR.ok(extendedBillServiceImpl.save(extendedBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param extendedBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/extendedbills/{id}")
  public XfR putUpdate(@RequestBody ExtendedBill extendedBill,@PathVariable Long id) {
      extendedBill.setId(id);
      return XfR.ok(extendedBillServiceImpl.updateById(extendedBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param extendedBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/extendedbills/{id}")
  public XfR patchUpdate(@RequestBody ExtendedBill extendedBill,@PathVariable Long id) {
      ExtendedBill upextendedBill = extendedBillServiceImpl.getById(id);
      if(upextendedBill != null){
        upextendedBill = ObjectCopyUtils.copyProperties(extendedBill,upextendedBill,true);
      }
      return XfR.ok(extendedBillServiceImpl.updateById(upextendedBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/extendedbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(extendedBillServiceImpl.removeById(id));
  }

}