package com.xforceplus.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.Invoice;
import com.xforceplus.sdktest.service.IInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-01
 */
@RestController
public class InvoiceController {

  @Autowired
  private IInvoiceService invoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoice ${table.comment}
   * @return
   */
  @GetMapping("/invoices" )
  public XfR getInvoices(XfPage page, Invoice invoice) {
    return XfR.ok(invoiceServiceImpl.page(page, Wrappers.query(invoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoices")
  public XfR save(@RequestBody Invoice invoice) {
     return XfR.ok(invoiceServiceImpl.save(invoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoices/{id}")
  public XfR putUpdate(@RequestBody Invoice invoice,@PathVariable Long id) {
      invoice.setId(id);
      return XfR.ok(invoiceServiceImpl.updateById(invoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoices/{id}")
  public XfR patchUpdate(@RequestBody Invoice invoice,@PathVariable Long id) {
      Invoice upinvoice = invoiceServiceImpl.getById(id);
      if(upinvoice != null){
        upinvoice = ObjectCopyUtils.copyProperties(invoice,upinvoice,true);
      }
      return XfR.ok(invoiceServiceImpl.updateById(upinvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceServiceImpl.removeById(id));
  }

}