package com.xforceplus.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.sdktest.entity.PytBill;
import com.xforceplus.sdktest.service.IPytBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-03-01
 */
@RestController
public class PytBillController {

  @Autowired
  private IPytBillService pytBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pytBill ${table.comment}
   * @return
   */
  @GetMapping("/pytbills" )
  public XfR getPytBills(XfPage page, PytBill pytBill) {
    return XfR.ok(pytBillServiceImpl.page(page, Wrappers.query(pytBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pytbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pytBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pytBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/pytbills")
  public XfR save(@RequestBody PytBill pytBill) {
     return XfR.ok(pytBillServiceImpl.save(pytBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pytBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/pytbills/{id}")
  public XfR putUpdate(@RequestBody PytBill pytBill,@PathVariable Long id) {
      pytBill.setId(id);
      return XfR.ok(pytBillServiceImpl.updateById(pytBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pytBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pytbills/{id}")
  public XfR patchUpdate(@RequestBody PytBill pytBill,@PathVariable Long id) {
      PytBill uppytBill = pytBillServiceImpl.getById(id);
      if(uppytBill != null){
        uppytBill = ObjectCopyUtils.copyProperties(pytBill,uppytBill,true);
      }
      return XfR.ok(pytBillServiceImpl.updateById(uppytBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pytbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pytBillServiceImpl.removeById(id));
  }

}