package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.Staff;
import com.xforceplus.eccpsupplierportal.service.IStaffService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-24
 */
@RestController
public class StaffController {

  @Autowired
  private IStaffService staffServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param staff ${table.comment}
   * @return
   */
  @GetMapping("/staffs" )
  public XfR getStaffs(XfPage page, Staff staff) {
    return XfR.ok(staffServiceImpl.page(page, Wrappers.query(staff)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/staffs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(staffServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param staff ${table.comment}
   * @return XfR
   */
  @PostMapping("/staffs")
  public XfR save(@RequestBody Staff staff) {
     return XfR.ok(staffServiceImpl.save(staff));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param staff ${table.comment}
   * @return XfR
   */
  @PutMapping("/staffs/{id}")
  public XfR putUpdate(@RequestBody Staff staff,@PathVariable Long id) {
      staff.setId(id);
      return XfR.ok(staffServiceImpl.updateById(staff));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param staff ${table.comment}
   * @return XfR
   */
  @PatchMapping("/staffs/{id}")
  public XfR patchUpdate(@RequestBody Staff staff,@PathVariable Long id) {
      Staff upstaff = staffServiceImpl.getById(id);
      if(upstaff != null){
        upstaff = ObjectCopyUtils.copyProperties(staff,upstaff,true);
      }
      return XfR.ok(staffServiceImpl.updateById(upstaff));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/staffs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(staffServiceImpl.removeById(id));
  }

  @PostMapping("/staffs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "staff");
      params.put("request", condition);

     return XfR.ok(staffServiceImpl.querys(params));
  }

}
