package com.xforceplus.standardcustomizesumitomo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.standardcustomizesumitomo.entity.AccountantInfo;
import com.xforceplus.standardcustomizesumitomo.service.IAccountantInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2020-12-17
 */
@RestController
public class AccountantInfoController {

  @Autowired
  private IAccountantInfoService accountantInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountantInfo ${table.comment}
   * @return
   */
  @GetMapping("/accountantinfos" )
  public XfR getAccountantInfos(XfPage page, AccountantInfo accountantInfo) {
    return XfR.ok(accountantInfoServiceImpl.page(page, Wrappers.query(accountantInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountantinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountantInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountantInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountantinfos")
  public XfR save(@RequestBody AccountantInfo accountantInfo) {
     return XfR.ok(accountantInfoServiceImpl.save(accountantInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountantInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountantinfos/{id}")
  public XfR putUpdate(@RequestBody AccountantInfo accountantInfo,@PathVariable Long id) {
      accountantInfo.setId(id);
      return XfR.ok(accountantInfoServiceImpl.updateById(accountantInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountantInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountantinfos/{id}")
  public XfR patchUpdate(@RequestBody AccountantInfo accountantInfo,@PathVariable Long id) {
      AccountantInfo upaccountantInfo = accountantInfoServiceImpl.getById(id);
      if(upaccountantInfo != null){
        upaccountantInfo = ObjectCopyUtils.copyProperties(accountantInfo,upaccountantInfo,true);
      }
      return XfR.ok(accountantInfoServiceImpl.updateById(upaccountantInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountantinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountantInfoServiceImpl.removeById(id));
  }

  @PostMapping("/accountantinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "accountant_info");
      params.put("request", condition);

     return XfR.ok(accountantInfoServiceImpl.querys(params));
  }

}
