package com.xforceplus.standardcustomizesumitomo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.standardcustomizesumitomo.entity.BillInfo;
import com.xforceplus.standardcustomizesumitomo.service.IBillInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2020-12-17
 */
@RestController
public class BillInfoController {

  @Autowired
  private IBillInfoService billInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billInfo ${table.comment}
   * @return
   */
  @GetMapping("/billinfos" )
  public XfR getBillInfos(XfPage page, BillInfo billInfo) {
    return XfR.ok(billInfoServiceImpl.page(page, Wrappers.query(billInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/billinfos")
  public XfR save(@RequestBody BillInfo billInfo) {
     return XfR.ok(billInfoServiceImpl.save(billInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/billinfos/{id}")
  public XfR putUpdate(@RequestBody BillInfo billInfo,@PathVariable Long id) {
      billInfo.setId(id);
      return XfR.ok(billInfoServiceImpl.updateById(billInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billinfos/{id}")
  public XfR patchUpdate(@RequestBody BillInfo billInfo,@PathVariable Long id) {
      BillInfo upbillInfo = billInfoServiceImpl.getById(id);
      if(upbillInfo != null){
        upbillInfo = ObjectCopyUtils.copyProperties(billInfo,upbillInfo,true);
      }
      return XfR.ok(billInfoServiceImpl.updateById(upbillInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billInfoServiceImpl.removeById(id));
  }

  @PostMapping("/billinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "bill_info");
      params.put("request", condition);

     return XfR.ok(billInfoServiceImpl.querys(params));
  }

}
