package com.xforceplus.standardcustomizesumitomo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.standardcustomizesumitomo.entity.InvoiceReport;
import com.xforceplus.standardcustomizesumitomo.service.IInvoiceReportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2020-12-17
 */
@RestController
public class InvoiceReportController {

  @Autowired
  private IInvoiceReportService invoiceReportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceReport ${table.comment}
   * @return
   */
  @GetMapping("/invoicereports" )
  public XfR getInvoiceReports(XfPage page, InvoiceReport invoiceReport) {
    return XfR.ok(invoiceReportServiceImpl.page(page, Wrappers.query(invoiceReport)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicereports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceReportServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceReport ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicereports")
  public XfR save(@RequestBody InvoiceReport invoiceReport) {
     return XfR.ok(invoiceReportServiceImpl.save(invoiceReport));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceReport ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicereports/{id}")
  public XfR putUpdate(@RequestBody InvoiceReport invoiceReport,@PathVariable Long id) {
      invoiceReport.setId(id);
      return XfR.ok(invoiceReportServiceImpl.updateById(invoiceReport));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceReport ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicereports/{id}")
  public XfR patchUpdate(@RequestBody InvoiceReport invoiceReport,@PathVariable Long id) {
      InvoiceReport upinvoiceReport = invoiceReportServiceImpl.getById(id);
      if(upinvoiceReport != null){
        upinvoiceReport = ObjectCopyUtils.copyProperties(invoiceReport,upinvoiceReport,true);
      }
      return XfR.ok(invoiceReportServiceImpl.updateById(upinvoiceReport));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicereports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceReportServiceImpl.removeById(id));
  }

  @PostMapping("/invoicereports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "invoice_report");
      params.put("request", condition);

     return XfR.ok(invoiceReportServiceImpl.querys(params));
  }

}
