/*
 *    Copyright (c) 2020-2027, wangzheng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the pig4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: wangzheng (wangzheng@xforceplus.com)
 */

package com.xforceplus.standardcustomizesumitomo.service.impl;

import com.xforceplus.standardcustomizesumitomo.entity.InvoiceMain;
import com.xforceplus.standardcustomizesumitomo.mapper.InvoiceMainMapper;
import com.xforceplus.standardcustomizesumitomo.service.IInvoiceMainService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;


/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author ultraman
 * @since 2020-12-17
 */
@BoService(value = "1338791658050482177")
@Service
public class InvoiceMainServiceImpl extends ServiceImpl<InvoiceMainMapper, InvoiceMain> implements IInvoiceMainService {

    @Override
    public List<Map> querys(Map<String, Object> params) {
        ConditionQueryRequest req = (ConditionQueryRequest) params.get("request");

        List<Map> result = this.baseMapper.querys(params);

        result.stream().forEach(rs ->
            req.getEntity().getEntities().stream()
            .filter(entity -> rs.containsKey(entity.getCode()))
            .forEach(entity -> {
                Map entityRs = (HashMap) rs.get(entity.getCode());
                entityRs.keySet().stream().forEach(key ->
                    rs.put(entity.getCode() + "." + key, entityRs.get(key))
                );
                rs.remove(entity.getCode());
            })
        );

        return result;
    }
}
