package com.xforceplus.standardplatform.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 电子底账状态
 * </p>
 *
 * @author ultraman
 * @since 2021-05-31
 */
public enum AuthStatusFromElectronicStatus {

    _0("0", "未获取"),
    _1("1", "未勾选"),
    _2("2", "已勾选"),
    _3("3", "底账确认失败"),
    _4("4", "已确认"),
    _5("5", "不可勾选确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuthStatusFromElectronicStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStatusFromElectronicStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
