package com.xforceplus.standardplatform.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 条件操作
 * </p>
 *
 * @author ultraman
 * @since 2021-05-31
 */
public enum ConditionOperation {

    EQ("eq", "等于"),
    LIKE("like", "模糊"),
    IN("in", "在范围内"),
    NOTIN("notin", "不在范围内"),
    RANGE("range", "区间"),
    GT("gt", "大于"),
    GE("ge", "大于等于"),
    LT("lt", "小于"),
    LE("le", "小于等于"),
    NE("ne", "不等于");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ConditionOperation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConditionOperation fromCode(String code){
        switch(code) {
            case "eq":
                return EQ;
            case "like":
                return LIKE;
            case "in":
                return IN;
            case "notin":
                return NOTIN;
            case "range":
                return RANGE;
            case "gt":
                return GT;
            case "ge":
                return GE;
            case "lt":
                return LT;
            case "le":
                return LE;
            case "ne":
                return NE;
            default:
                return null;
        }
    }
}
