package com.xforceplus.standardplatform.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2021-05-31
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    SE("se", "增值税电子专用发票"),
    CE("ce", "增值税电子普通发票/电子普通发票（区块链）"),
    JU("ju", "增值税普通发票（卷票）"),
    V("v", "机动车统一销售发票"),
    T("t", "通用机打发票"),
    CT("ct", "增值税电子普通发票（通行费）"),
    VS("vs", "二手车销售统一发票"),
    CP("cp", "海关缴款书"),
    CD("cd", "通用电子发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "se":
                return SE;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "v":
                return V;
            case "t":
                return T;
            case "ct":
                return CT;
            case "vs":
                return VS;
            case "cp":
                return CP;
            case "cd":
                return CD;
            default:
                return null;
        }
    }
}
