package com.xforceplus.standardplatform.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红冲状态
 * </p>
 *
 * @author ultraman
 * @since 2021-05-31
 */
public enum ReverseFlag {

    _0("0", "正常"),
    _3("3", "已完整红冲"),
    _4("4", "已部分红冲");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReverseFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReverseFlag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
