package com.xforceplus.studydongrujing.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studydongrujing.entity.PreInvoiceBatch;
import com.xforceplus.studydongrujing.service.IPreInvoiceBatchService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-19
 */
@RestController
public class PreInvoiceBatchController {

  @Autowired
  private IPreInvoiceBatchService preInvoiceBatchServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param preInvoiceBatch ${table.comment}
   * @return
   */
  @GetMapping("/preinvoicebatchs" )
  public XfR getPreInvoiceBatchs(XfPage page, PreInvoiceBatch preInvoiceBatch) {
    return XfR.ok(preInvoiceBatchServiceImpl.page(page, Wrappers.query(preInvoiceBatch)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/preinvoicebatchs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(preInvoiceBatchServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param preInvoiceBatch ${table.comment}
   * @return XfR
   */
  @PostMapping("/preinvoicebatchs")
  public XfR save(@RequestBody PreInvoiceBatch preInvoiceBatch) {
     return XfR.ok(preInvoiceBatchServiceImpl.save(preInvoiceBatch));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param preInvoiceBatch ${table.comment}
   * @return XfR
   */
  @PutMapping("/preinvoicebatchs/{id}")
  public XfR putUpdate(@RequestBody PreInvoiceBatch preInvoiceBatch,@PathVariable Long id) {
      preInvoiceBatch.setId(id);
      return XfR.ok(preInvoiceBatchServiceImpl.updateById(preInvoiceBatch));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param preInvoiceBatch ${table.comment}
   * @return XfR
   */
  @PatchMapping("/preinvoicebatchs/{id}")
  public XfR patchUpdate(@RequestBody PreInvoiceBatch preInvoiceBatch,@PathVariable Long id) {
      PreInvoiceBatch uppreInvoiceBatch = preInvoiceBatchServiceImpl.getById(id);
      if(uppreInvoiceBatch != null){
        uppreInvoiceBatch = ObjectCopyUtils.copyProperties(preInvoiceBatch,uppreInvoiceBatch,true);
      }
      return XfR.ok(preInvoiceBatchServiceImpl.updateById(uppreInvoiceBatch));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/preinvoicebatchs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(preInvoiceBatchServiceImpl.removeById(id));
  }

  @PostMapping("/preinvoicebatchs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pre_invoice_batch");
     params.put("request", condition);

     return XfR.ok(preInvoiceBatchServiceImpl.querys(params));
  }

}
